# バッチ設計書 14-npm run test-treeshake

## 概要

本ドキュメントは、three.jsプロジェクトにおけるtree-shakingテストバッチ `npm run test-treeshake` の設計仕様を定義する。

### 本バッチの処理概要

Rollupを使用して最小構成のthree.jsアプリケーションをバンドルし、tree-shaking（未使用コードの除去）が正しく機能しているかを検証するテストバッチである。WebGL版、WebGPU版、WebGPU Nodes版の3種類について、最小構成でのバンドルサイズを計測する。

**業務上の目的・背景**：three.jsは大規模なライブラリであり、全機能をバンドルすると非常に大きなファイルサイズになる。モダンなバンドラーはtree-shaking機能により未使用コードを除去できるが、ライブラリ側でESモジュールの適切な設計がされていないとtree-shakingが効かない。このバッチは、最小構成（カメラ、シーン、レンダラー、空のレンダリングループ）でバンドルした際のサイズを検証し、tree-shakingが期待通り機能していることを確認する。

**バッチの実行タイミング**：PRトリガーで自動実行（read-size.yml、report-size.ymlワークフローの一部）、または開発者によるローカル環境での手動実行。

**主要な処理内容**：
1. test/treeshake/index.js（WebGL版エントリポイント）をRollupでバンドル
2. test/treeshake/index.webgpu.js（WebGPU版エントリポイント）をRollupでバンドル
3. test/treeshake/index.webgpu.nodes.js（WebGPU Nodes版エントリポイント）をRollupでバンドル
4. 各版について非圧縮版とminified版を生成
5. バンドルサイズをコンソールに出力

**前後の処理との関連**：`npm run build`による完全ビルド後に実行。CI環境ではread-size.ymlでバンドルサイズを取得し、report-size.ymlでPRにコメントとして結果を投稿する。

**影響範囲**：test/treeshake/ディレクトリへのバンドルファイル出力。

## バッチ種別

バンドルテスト / パフォーマンステスト / tree-shaking検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PRごと、手動実行） |
| 実行時刻 | 不定 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | PRイベント（src/, package.json, utils/build/変更時）/ 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 24以上がインストールされていること |
| 依存パッケージ | `npm ci`による依存関係のインストール完了 |
| ビルド完了 | `npm run build`によるthree.jsフルビルドの完了 |

### 実行可否判定

- build/ディレクトリにthree.module.js、three.webgpu.js等が存在すること
- test/treeshake/配下のエントリポイントファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/treeshake/index.js | JavaScriptファイル | WebGL版tree-shakeテストエントリポイント |
| test/treeshake/index.webgpu.js | JavaScriptファイル | WebGPU版tree-shakeテストエントリポイント |
| test/treeshake/index.webgpu.nodes.js | JavaScriptファイル | WebGPU Nodes版tree-shakeテストエントリポイント |
| test/rollup.treeshake.config.js | JavaScriptファイル | Rollup設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| test/treeshake/index.bundle.js | JavaScriptファイル | WebGL版バンドル（非圧縮） |
| test/treeshake/index.bundle.min.js | JavaScriptファイル | WebGL版バンドル（minified） |
| test/treeshake/index.webgpu.bundle.js | JavaScriptファイル | WebGPU版バンドル（非圧縮） |
| test/treeshake/index.webgpu.bundle.min.js | JavaScriptファイル | WebGPU版バンドル（minified） |
| test/treeshake/index.webgpu.nodes.bundle.js | JavaScriptファイル | WebGPU Nodes版バンドル（非圧縮） |
| test/treeshake/index.webgpu.nodes.bundle.min.js | JavaScriptファイル | WebGPU Nodes版バンドル（minified） |
| stdout | テキスト | バンドルサイズのコンソール出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | index.bundle.js, index.bundle.min.js, index.webgpu.bundle.js等 |
| 出力先 | test/treeshake/ |
| 文字コード | UTF-8 |
| 形式 | ESモジュール |

## 処理フロー

### 処理シーケンス

```
1. WebGL版バンドル生成（非圧縮）
   └─ test/treeshake/index.js → index.bundle.js

2. WebGL版バンドル生成（minified）
   └─ test/treeshake/index.js → index.bundle.min.js
   └─ ファイルサイズをコンソール出力

3. WebGPU版バンドル生成（非圧縮）
   └─ test/treeshake/index.webgpu.js → index.webgpu.bundle.js

4. WebGPU版バンドル生成（minified）
   └─ test/treeshake/index.webgpu.js → index.webgpu.bundle.min.js
   └─ ファイルサイズをコンソール出力

5. WebGPU Nodes版バンドル生成（非圧縮）
   └─ test/treeshake/index.webgpu.nodes.js → index.webgpu.nodes.bundle.js

6. WebGPU Nodes版バンドル生成（minified）
   └─ test/treeshake/index.webgpu.nodes.js → index.webgpu.nodes.bundle.min.js
   └─ ファイルサイズをコンソール出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rollup設定読み込み]
    B --> C[WebGL版バンドル生成<br>index.js → index.bundle.js]
    C --> D[WebGL版minifiedバンドル生成<br>index.js → index.bundle.min.js]
    D --> E[WebGL版サイズ出力]
    E --> F[WebGPU版バンドル生成<br>index.webgpu.js → index.webgpu.bundle.js]
    F --> G[WebGPU版minifiedバンドル生成<br>index.webgpu.js → index.webgpu.bundle.min.js]
    G --> H[WebGPU版サイズ出力]
    H --> I[WebGPU Nodes版バンドル生成<br>index.webgpu.nodes.js → index.webgpu.nodes.bundle.js]
    I --> J[WebGPU Nodes版minifiedバンドル生成<br>index.webgpu.nodes.js → index.webgpu.nodes.bundle.min.js]
    J --> K[WebGPU Nodes版サイズ出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルドエラー | ソースコードに構文エラーがある | コードを修正 |
| - | インポートエラー | 依存関係が解決できない | npm ciを再実行、またはコードを修正 |
| - | 循環依存 | モジュール間に循環依存がある | コード構造を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. Rollupのエラーメッセージを確認
2. 該当するソースコードを修正
3. `npm run build`で再ビルド後、再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 6ファイル（3種類 x 2バリエーション） |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | Rollupバンドラー依存 |

## 排他制御

- 同時実行に関する制約なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各バンドル生成完了時 | Destination、Bundle Size、Gzipped Size |

出力形式例:
```
┌─────────────────────────────────────────────────────┐
│                                                     │
│   Destination:  test/treeshake/index.bundle.min.js │
│   Bundle Size:  XXX.XX KB                           │
│   Gzipped Size: XX.XX KB                            │
│                                                     │
└─────────────────────────────────────────────────────┘
```

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| バンドルサイズ増加 | PRごとに比較 | GitHub PR comment（report-size.ymlによる） |

## 備考

- 各エントリポイントは最小構成（PerspectiveCamera、Scene、Renderer、空のレンダリングループ）のみを含む
- terserプラグインによりminificationを実行
- filesizeプラグイン（カスタム）によりバンドルサイズとgzip圧縮後サイズを出力
- CI環境ではこのテストの出力を使用してPRにバンドルサイズの変化をコメントする
